/* Unzip.java */

import java.io.*;
import java.util.zip.*;

public class Unzip
{
  public static void main(String[] args)
  {
    if (args.length != 1) {
      System.out.println("Usage: java Unzip zipfile");
      System.exit(1);
    }
    try {
      byte[] buf = new byte[4096];
      ZipInputStream in = new ZipInputStream(
                          new FileInputStream(args[0]));
      while (true) {
        //Nchsten Eintrag lesen
        ZipEntry entry = in.getNextEntry();
        if (entry == null) {
          break;
        }
        //Beschreibung ausgeben
        System.out.println(
          entry.getName() +
          " (" + entry.getCompressedSize() + "/" +
          entry.getSize() + ")"
        );
        //Ausgabedatei erzeugen
        FileOutputStream out = new FileOutputStream(
          entry.getName()
        );
        int len;
        while ((len = in.read(buf)) > 0) {
          out.write(buf, 0, len);
        }
        out.close();
        //Eintrag schlieen
        in.closeEntry();
      }
      in.close();
    } catch (IOException e) {
      System.err.println(e.toString());
    }
  }
}