/* Zip.java */

import java.io.*;
import java.util.zip.*;

public class Zip
{
  public static void main(String[] args)
  {
    if (args.length < 2) {
      System.out.println("Usage: java Zip zipfile files...");
      System.exit(1);
    }
    try {
      byte[] buf = new byte[4096];
      ZipOutputStream out = new ZipOutputStream(
                            new FileOutputStream(args[0]));
      for (int i = 1; i < args.length; ++i) {
        String fname = args[i];
        System.out.println("adding " + fname);
        FileInputStream in = new FileInputStream(fname);
        out.putNextEntry(new ZipEntry(fname));
        int len;
        while ((len = in.read(buf)) > 0) {
          out.write(buf, 0, len);
        }
        in.close();
      }
      out.close();
    } catch (IOException e) {
      System.err.println(e.toString());
    }
  }
}