/*
 * File........: c:/ARC/PROG/java/gk/lscript/GraphicPlugin.java
 * Package.....: gk.lscript
 * Created.....: 98/08/10, Guido Krueger
 * RCS.........: $Revision: 1.4 $
 *               $Date: 1998/08/15 01:17:36 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

import java.awt.*;

public class GraphicPlugin
extends LScriptPlugin
{
  //Function numbers constants----------------------------------------
  private final int FUNC_SETCOLOR      =  1;
  private final int FUNC_SETBACKGROUND =  2;
  private final int FUNC_DRAWLINE      =  3;
  private final int FUNC_DRAWSTRING    =  4;
  private final int FUNC_DRAWRECT      =  5;
  private final int FUNC_FILLRECT      =  6;
  private final int FUNC_DRAWOVAL      =  7;
  private final int FUNC_FILLOVAL      =  8;
  private final int FUNC_DRAWARC       =  9;
  private final int FUNC_FILLARC       = 10;
  private final int FUNC_SETFONT       = 11;

  //Instance variables----------------------------------------
  protected Eval eval;
  protected Graphics g;
  protected Component comp;

  public GraphicPlugin()
  {
  }

  public void init(Eval eval)
  throws LScriptException
  {
	this.eval = eval;
	this.g = null;
	this.comp = null;
	//Functions
	eval.registerFunction("setcolor",      this, FUNC_SETCOLOR);
	eval.registerFunction("setbackground", this, FUNC_SETBACKGROUND);
	eval.registerFunction("drawline",      this, FUNC_DRAWLINE);
	eval.registerFunction("drawstring",    this, FUNC_DRAWSTRING);
	eval.registerFunction("drawrect",      this, FUNC_DRAWRECT);
	eval.registerFunction("fillrect",      this, FUNC_FILLRECT);
	eval.registerFunction("drawoval",      this, FUNC_DRAWOVAL);
	eval.registerFunction("filloval",      this, FUNC_FILLOVAL);
	eval.registerFunction("drawarc",       this, FUNC_DRAWARC);
	eval.registerFunction("fillarc",       this, FUNC_FILLARC);
	eval.registerFunction("setfont",       this, FUNC_SETFONT);
  }

  public void setComponent(Component comp)
  {
	this.comp = comp;
  }

  public void setGraphics(Graphics g)
  {
	this.g = g;
  }

  public Term execute(int funcnum, Term paras, int paracnt)
  throws LScriptException
  {
	Term ret = null;
	switch (funcnum) {
	case FUNC_SETCOLOR:
	  ret = setcolor(paras, paracnt, false);
	  break;
	case FUNC_SETBACKGROUND:
	  ret = setcolor(paras, paracnt, true);
	  break;
	case FUNC_DRAWLINE:
	  ret = drawline(paras, paracnt);
	  break;
	case FUNC_DRAWSTRING:
	  ret = drawstring(paras, paracnt);
	  break;
	case FUNC_DRAWRECT:
	  ret = drawrect(paras, paracnt, false);
	  break;
	case FUNC_FILLRECT:
	  ret = drawrect(paras, paracnt, true);
	  break;
	case FUNC_DRAWOVAL:
	  ret = drawoval(paras, paracnt, false);
	  break;
	case FUNC_FILLOVAL:
	  ret = drawoval(paras, paracnt, true);
	  break;
	case FUNC_DRAWARC:
	  ret = drawarc(paras, paracnt, false);
	  break;
	case FUNC_FILLARC:
	  ret = drawarc(paras, paracnt, true);
	  break;
	case FUNC_SETFONT:
	  ret = setfont(paras, paracnt);
	  break;
	default:
	  throw new LScriptException(
        "internal error: unknown function number in GraphicPlugin"
	  );
	}
	return ret;
  }

  public void destroy()
  {
  }

  //Function implementations----------------------------------------
  private Term setcolor(Term args, int paracnt, boolean background)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("NNN", args, paracnt, false, 1);
	if (g != null) {
	  int red   = ((NumberTerm)paras[0]).getAsInt();
	  int green = ((NumberTerm)paras[1]).getAsInt();
	  int blue  = ((NumberTerm)paras[2]).getAsInt();
	  if (background) {
		comp.setBackground(new Color(red, green, blue));
	  } else {
		g.setColor(new Color(red, green, blue));
	  }
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

  private Term drawline(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("NNNN", args, paracnt, false, 1);
	if (g != null) {
	  int x1 = ((NumberTerm)paras[0]).getAsInt();
	  int y1 = ((NumberTerm)paras[1]).getAsInt();
	  int x2 = ((NumberTerm)paras[2]).getAsInt();
	  int y2 = ((NumberTerm)paras[3]).getAsInt();
	  g.drawLine(x1, y1, x2, y2);
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

  private Term drawstring(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("SNN", args, paracnt, false, 1);
	if (g != null) {
	  String s = paras[0].toString();
	  int x = ((NumberTerm)paras[1]).getAsInt();
	  int y = ((NumberTerm)paras[2]).getAsInt();
	  g.drawString(s, x, y);
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

  private Term drawrect(Term args, int paracnt, boolean fill)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("NNNN", args, paracnt, false, 1);
	if (g != null) {
	  int x = ((NumberTerm)paras[0]).getAsInt();
	  int y = ((NumberTerm)paras[1]).getAsInt();
	  int width = ((NumberTerm)paras[2]).getAsInt();
	  int height = ((NumberTerm)paras[3]).getAsInt();
	  if (fill) {
		g.fillRect(x, y, width, height);
	  } else {
		g.drawRect(x, y, width, height);
	  }
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

  private Term drawoval(Term args, int paracnt, boolean fill)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("NNNN", args, paracnt, false, 1);
	if (g != null) {
	  int x = ((NumberTerm)paras[0]).getAsInt();
	  int y = ((NumberTerm)paras[1]).getAsInt();
	  int width = ((NumberTerm)paras[2]).getAsInt();
	  int height = ((NumberTerm)paras[3]).getAsInt();
	  if (fill) {
		g.fillOval(x, y, width, height);
	  } else {
		g.drawOval(x, y, width, height);
	  }
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

  private Term drawarc(Term args, int paracnt, boolean fill)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("NNNNNN", args, paracnt, false, 1);
	if (g != null) {
	  int x = ((NumberTerm)paras[0]).getAsInt();
	  int y = ((NumberTerm)paras[1]).getAsInt();
	  int width = ((NumberTerm)paras[2]).getAsInt();
	  int height = ((NumberTerm)paras[3]).getAsInt();
	  int startangle = ((NumberTerm)paras[4]).getAsInt();
	  int arcangle = ((NumberTerm)paras[5]).getAsInt();
	  if (fill) {
		g.fillArc(x, y, width, height, startangle, arcangle);
	  } else {
		g.drawArc(x, y, width, height, startangle, arcangle);
	  }
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

  private Term setfont(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("SNN", args, paracnt, false, 1);
	if (g != null) {
	  String name = paras[0].toString();
	  int style = ((NumberTerm)paras[1]).getAsInt();
	  int size = ((NumberTerm)paras[2]).getAsInt();
	  g.setFont(new Font(name, style, size));
	  return new SymbolTerm("T");
	} else {
	  return new ListTerm();
	}
  }

}
