/*
 * File........: c:/ARC/PROG/java/gk/lscript/LScript.java
 * Package.....: gk.
 * Created.....: 98/08/08, Guido Krueger
 * RCS.........: $Revision: 1.3 $
 *               $Date: 1998/08/13 22:26:19 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

import java.io.*;

public class LScript
{
  public static void main(String args[])
  {
	if (args.length != 1) {
	  System.out.println("usage: java LScript (lisp-prog | @lisp-file)");
	  System.exit(1);
	}
	//Initialize parser
	Parser parser = null;
	if (args[0].startsWith("@")) {
	  try {
		parser = new Parser(new FileReader(args[0].substring(1)));
	  } catch (FileNotFoundException e) {
		System.out.println(e.toString());
		System.exit(1);
	  }
	} else {
	  parser = new Parser(new StringReader(args[0]));
	}
	//Initialize eval
	Eval eval = new Eval();
	try {
	  eval.addPlugin(new CorePlugin());
	  eval.addPlugin(new StringPlugin());
	  eval.addPlugin(new NumberPlugin());
	  eval.addPlugin(new ListPlugin());
	  eval.addPlugin(new PredicatePlugin());
	  //Main loop
	  while (true) {
		Term term = parser.nextTerm();
		if (term == null) {
		  System.out.println("<eof>");
		  break;
		}
		try {
		  term = eval.eval(term);
		} catch (LScriptException e) {
		  //re-throw with line number added
		  e.setLine(parser.getLine());
		  throw e;
		}
	  }
	} catch (LScriptException e) {
	  System.err.println(e.toString());
	  System.exit(1);
	} finally {
	  eval.destroy();
	}
  }
}
