/*
 * File........: c:/ARC/PROG/java/gk/lscript/LScriptException.java
 * Package.....: gk.lscript
 * Created.....: 98/08/08, Guido Krueger
 * RCS.........: $Revision: 1.3 $
 *               $Date: 1998/08/15 01:17:36 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

/**
 * The LScript language excpetion class.
 */
public class LScriptException
extends Exception
{
  //Constants
  public static final int ERROR = 1;
  public static final int QUIT  = 2;
  public static final int BREAK = 3;

  //Instance variables 
  protected String msg;
  protected int    line;
  protected int    type;

  /**
   * Creates a new LScriptException.
   */
  public LScriptException(String msg)
  {
	this.msg = msg;
	line = -1;
	type = ERROR;
  }

  /**
   * Sets the line number to the given value.
   */
  public void setLine(int linenum)
  {
	line = linenum;
  }

  /**
   * Sets the exception type to the given value.
   */
  public void setType(int type)
  {
	this.type = type;
  }

  /**
   * Returns this object's exception type.
   */
  public int getType()
  {
	return type;
  }

  /**
   * Returns a String message indicating the error.
   */
  public String toString()
  {
	if (type == QUIT) {
	  return "Program terminated by quit function";
	} else if (type == BREAK) {
	  return "Loop terminated by break function";
	} else if (line != -1) {
	  return "***Error at line " + line + ": " + msg;
	} else {
	  return "***Error: " + msg;
	}
  }
}
