/*
 * File........: c:/ARC/PROG/java/gk/lscript/LscriptTestApplet.java
 * Package.....: gk.
 * Created.....: 98/08/10, Guido Krueger
 * RCS.........: $Revision: 1.3 $
 *               $Date: 1998/11/14 22:07:58 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

import java.awt.*;
import java.applet.*;
import java.io.*;
import gk.lscript.*;

public class LScriptTestApplet
extends Applet
{
  //Instance variables
  Parser parser;
  Eval eval;
  GraphicPlugin gp;
  String paintcmd;

  public void init()
  {
	eval = new Eval();
	try {
	  eval.addPlugin(new CorePlugin());
	  eval.addPlugin(new StringPlugin());
	  eval.addPlugin(new NumberPlugin());
	  eval.addPlugin(new ListPlugin());
	  eval.addPlugin(new PredicatePlugin());
	  eval.addPlugin((gp = new GraphicPlugin()));
	} catch (LScriptException e) {
	  showStatus(e.toString());
	  System.out.println(e.toString());
	}
	paintcmd = getParameter("paintcmd");
  }

  public void paint(Graphics g)
  {
	gp.setComponent(this);
	gp.setGraphics(g);
	parser = new Parser(new StringReader(paintcmd));
	try {
	  while (true) {
		Term term = parser.nextTerm();
		if (term == null) {
		  break;
		}
		try {
		  term = eval.eval(term);
		} catch (LScriptException e) {
		  //re-throw with line number added
		  e.setLine(parser.getLine());
		  throw e;
		}
	  }
	} catch (LScriptException e) {
	  showStatus(e.toString());
	  System.out.println(e.toString());
	}
	gp.setGraphics(null);
	gp.setComponent(null);
  }

  public void destroy()
  {
	eval.destroy();
  }

  public static void main(String args[])
  {
	System.out.println("Hello");
  }
}
