/*
 * File........: c:/ARC/PROG/java/gk/lscript/ListPlugin.java
 * Package.....: gk.lscript
 * Created.....: 98/08/09, Guido Krueger
 * RCS.........: $Revision: 1.4 $
 *               $Date: 1998/08/13 23:51:34 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

public class ListPlugin
extends LScriptPlugin
{
  //Function numbers constants----------------------------------------
  private final int FUNC_CAR       =  1;
  private final int FUNC_CDR       =  2;
  private final int FUNC_CONS      =  3;
  private final int FUNC_TCONS     =  4;
  private final int FUNC_LIST      =  5;
  private final int FUNC_APPEND    =  6;

  //Instance variables----------------------------------------
  protected Eval eval;

  public ListPlugin()
  {
  }

  public void init(Eval eval)
  throws LScriptException
  {
	this.eval = eval;
	//Functions
	eval.registerFunction("car",      this, FUNC_CAR);
	eval.registerFunction("cdr",      this, FUNC_CDR);
	eval.registerFunction("cons",     this, FUNC_CONS);
	eval.registerFunction("tcons",    this, FUNC_TCONS);
	eval.registerFunction("list",     this, FUNC_LIST);
	eval.registerFunction("append",   this, FUNC_APPEND);
  }

  public Term execute(int funcnum, Term paras, int paracnt)
  throws LScriptException
  {
	Term ret = null;
	switch (funcnum) {
	case FUNC_CAR:
	  ret = car(paras, paracnt);
	  break;
	case FUNC_CDR:
	  ret = cdr(paras, paracnt);
	  break;
	case FUNC_CONS:
	  ret = cons(paras, paracnt);
	  break;
	case FUNC_TCONS:
	  ret = tcons(paras, paracnt);
	  break;
	case FUNC_LIST:
	  ret = list(paras, paracnt);
	  break;
	case FUNC_APPEND:
	  ret = append(paras, paracnt);
	  break;
	default:
	  throw new LScriptException(
        "internal error: unknown function number in ListPlugin"
	  );
	}
	return ret;
  }

  public void destroy()
  {
  }

  //Function implementations----------------------------------------
  private Term car(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("L", args, paracnt, false, 1);
	ListTerm list = (ListTerm)paras[0];
	if (list.isEmpty()) {
	  throw new LScriptException("cannot car on empty list");
	}
	return list.getHead();
  }

  private Term cdr(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("L", args, paracnt, false, 1);
	ListTerm list = (ListTerm)paras[0];
	return list.getTail();
  }

  private Term cons(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("?L", args, paracnt, false, 1);
	ListTerm list = (ListTerm)(paras[1].cloneterm());
	return list.addHeadElement(paras[0].cloneterm());
  }

  private Term tcons(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("L?", args, paracnt, false, 1);
	ListTerm list = (ListTerm)(paras[0].cloneterm());
	return list.addElement(paras[1].cloneterm());
  }

  private Term list(Term args, int paracnt)
  throws LScriptException
  {
	ListTerm ret = new ListTerm();
	while (args != null) {
	  ret.addElement(eval.eval(args).cloneterm());
	  args = args.next;
	}
	return ret;
  }

  private Term append(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("LL", args, paracnt, false, 1);
	ListTerm ret = new ListTerm();
	ListTerm list1 = (ListTerm)paras[0];
	while (!list1.isEmpty()) {
	  ret.addElement(list1.getHead().cloneterm());
	  list1 = list1.getTail();
	}
	ListTerm list2 = (ListTerm)paras[1];
	while (!list2.isEmpty()) {
	  ret.addElement(list2.getHead().cloneterm());
	  list2 = list2.getTail();
	}
	return ret;
  }
}
