/*
 * File........: c:/ARC/PROG/java/gk/lscript/ListTerm.java
 * Package.....: gk.lscript
 * Created.....: 98/08/06, Guido Krueger
 * RCS.........: $Revision: 1.3 $
 *               $Date: 1998/08/13 22:26:19 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

public class ListTerm
extends Term
{
  //Instance variables----------------------------------------
  private Term first;
  private Term last;
  private int  size;

  /** 
   * Creates a new empty list.
   */
  public ListTerm()
  {
	type = LIST;
	first = null;
	last = null;
	size = 0;
  }

  /** 
   * This private constructor is used in getTail() to create a new
   * list from the tail of the current list. 
   */
  private ListTerm(Term first, Term last, int size)
  {
	type = LIST;
	this.first = first;
	this.last = last;
	this.size = size;
  }

  /**
   * Returns a clone of the object.
   */
  public Term cloneterm()
  {
	ListTerm list = new ListTerm();
	Term tmp = first;
	while (tmp != null) {
	  list.addElement(tmp.cloneterm());
	  tmp = tmp.next;
	}
	return list;
  }

  /**
   * Adds a new element to the end of the list. Returns itself. The caller 
   * should take care not to add an element which aliased otherwise. Since
   * addElement() modifies the term.next pointer, garbage would result.
   */
  public ListTerm addElement(Term term)
  {
	if (first == null) {
	  first = term;
	  last = term;
	  term.next = null;
	  size = 1;
	} else {
	  last.next = term;
	  term.next = null;
	  last = term;
	  ++size;
	}
	return this;
  }

  /**
   * Adds a new element to the head of the list (according to the LISP
   * "cons" function). Returns itself. The caller should take care not 
   * to add an element which aliased otherwise. Since addHeadElement() 
   * modifies the term.next pointer, garbage would result.
   */
  public ListTerm addHeadElement(Term term)
  {
	if (first == null) {
	  addElement(term);
	} else {
	  term.next = first;
	  first = term;
	  ++size;
	}
	return this;
  }

  /**
   * Returns true if the list is empty. Otherwise, false is returned.
   */
  public boolean isEmpty()
  {
	return first == null;
  }

  /**
   * Returns the number of elements in the list.
   */
  public int length()
  {
	return size;
  }

  /**
   * Returns the head element of the list. If the list is empty, null
   * is returned.
   */
  public Term getHead()
  {
	return first;
  }

  /**
   * Returns the tail of the list (i.e. all elements after the head). If
   * the list is empty or has only a single element, an empty list is returned.
   */
  public ListTerm getTail()
  {
	ListTerm ret = null;
	if (first == null || first == last) {
	  ret = new ListTerm();
	} else {
	  ret = new ListTerm(first.next, last, size - 1);
	}
	return ret;
  }

  /**
   * Returns the list as a String.
   */
  public String toString()
  {
	StringBuffer ret = new StringBuffer(100);
	ret.append("(");
	Term tmp = first;
	while (tmp != null) {
	  if (tmp != first) {
		ret.append(' ');
	  }
	  ret.append(tmp.toString());
	  tmp = tmp.next;
	}
	ret.append(")");
	return ret.toString();
  }
}
