/*
 * File........: c:/ARC/PROG/java/gk/lscript/NumberTerm.java
 * Package.....: gk.lscript
 * Created.....: 98/08/06, Guido Krueger
 * RCS.........: $Revision: 1.4 $
 *               $Date: 1998/08/13 22:26:19 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

public class NumberTerm
extends Term
implements Cloneable
{
  //Instance variables----------------------------------------
  private boolean isint;
  private int     intvalue;
  private double  doublevalue;

  /**
   * Creates a new NumberTerm from the given integer value.
   */
  public NumberTerm(int value)
  {
	isint = true;
	intvalue = value;
	type = NUMBER;
  }

  /**
   * Creates a new NumberTerm from the given floating point value.
   */
  public NumberTerm(double value)
  {
	isint = false;
	doublevalue = value;
	type = NUMBER;
  }

  /**
   * Returns a clone of the object.
   */
  public Term cloneterm()
  {
	if (isint) {
	  return new NumberTerm(intvalue);
	} else {
	  return new NumberTerm(doublevalue);
	}
  }

  /**
   * Returns true if the object stores a whole number. Otherwise, it
   * returns false.
   */
  public boolean isInt()
  {
	return isint;
  }

  /**
   * Returns the value as an int. If the object represents a floating
   * point number, its internal value is casted to an int.
   */
  public int getAsInt()
  {
	return isint ? intvalue : (int)doublevalue;
  }

  /**
   * Returns the value as a double.
   */
  public double getAsDouble()
  {
	return isint ? intvalue : doublevalue;
  }

  /**
   * Returns a String representation of the object's value.
   */
  public String toString()
  {
	return isint ? Integer.toString(intvalue) : Double.toString(doublevalue);
  }
}
