/*
 * File........: c:/ARC/PROG/java/gk/lscript/StringPlugin.java
 * Package.....: gk.lscript
 * Created.....: 98/08/08, Guido Krueger
 * RCS.........: $Revision: 1.3 $
 *               $Date: 1998/08/13 23:51:34 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

public class StringPlugin
extends LScriptPlugin
{
  //Function numbers constants----------------------------------------
  private final int FUNC_LEFT     = 1;
  private final int FUNC_RIGHT    = 2;
  private final int FUNC_SUBSTR   = 3;
  private final int FUNC_LEN      = 4;
  private final int FUNC_CONCAT   = 5;
  private final int FUNC_INDEXOF  = 6;
  private final int FUNC_TOSTRING = 7;

  //Instance variables----------------------------------------
  protected Eval eval;

  public StringPlugin()
  {
  }

  public void init(Eval eval)
  throws LScriptException
  {
	this.eval = eval;
	eval.registerFunction("left",     this, FUNC_LEFT);
	eval.registerFunction("right",    this, FUNC_RIGHT);
	eval.registerFunction("substr",   this, FUNC_SUBSTR);
	eval.registerFunction("len",      this, FUNC_LEN);
	eval.registerFunction("concat",   this, FUNC_CONCAT);
	eval.registerFunction("indexof",  this, FUNC_INDEXOF);
	eval.registerFunction("tostring", this, FUNC_TOSTRING);
  }

  public Term execute(int funcnum, Term paras, int paracnt)
  throws LScriptException
  {
	Term ret = null;
	switch (funcnum) {
	case FUNC_LEFT:
	  ret = left(paras, paracnt);
	  break;
	case FUNC_RIGHT:
	  ret = right(paras, paracnt);
	  break;
	case FUNC_SUBSTR:
	  ret = substr(paras, paracnt);
	  break;
	case FUNC_LEN:
	  ret = len(paras, paracnt);
	  break;
	case FUNC_CONCAT:
	  ret = concat(paras, paracnt);
	  break;
	case FUNC_INDEXOF:
	  ret = indexof(paras, paracnt);
	  break;
	case FUNC_TOSTRING:
	  ret = tostring(paras, paracnt);
	  break;
	default:
	  throw new LScriptException(
        "internal error: unknown function number in StringPlugin"
	  );
	}
	return ret;
  }

  public void destroy()
  {
  }

  //Function implementations----------------------------------------
  private Term left(Term args, int paracnt)
  throws LScriptException
  {
	StringTerm ret = null;
	Term[] paras = eval.chkParas("SN", args, paracnt, false, 1);
	StringTerm p1 = (StringTerm)paras[0];
	NumberTerm p2 = (NumberTerm)paras[1];
	String s = p1.toString();
	int len = p2.getAsInt();
	if (len < 0) {
	  throw new LScriptException("non-negative number expected at arg 2");
	} else if (len == 0) {
	  ret = new StringTerm("");
	} else if (s.length() <= len) {
	  ret = new StringTerm(s);
	} else {
	  ret = new StringTerm(s.substring(0, len));
	}
	return ret;
  }

  private Term right(Term args, int paracnt)
  throws LScriptException
  {
	StringTerm ret = null;
	Term[] paras = eval.chkParas("SN", args, paracnt, false, 1);
	StringTerm p1 = (StringTerm)paras[0];
	NumberTerm p2 = (NumberTerm)paras[1];
	String s = p1.toString();
	int len = p2.getAsInt();
	if (len < 0) {
	  throw new LScriptException("non-negative number expected at arg 2");
	} else if (len == 0) {
	  ret = new StringTerm("");
	} else if (s.length() <= len) {
	  ret = new StringTerm(s);
	} else {
	  ret = new StringTerm(s.substring(s.length() - len));
	}
	return ret;
  }

  private Term substr(Term args, int paracnt)
  throws LScriptException
  {
	StringTerm ret = null;
	Term[] paras = eval.chkParas("SNN", args, paracnt, false, 1);
	StringTerm p1 = (StringTerm)paras[0];
	NumberTerm p2 = (NumberTerm)paras[1];
	NumberTerm p3 = (NumberTerm)paras[2];
	String s = p1.toString();
	int slen = s.length();
	int offs = p2.getAsInt();
	int len = p3.getAsInt();
	if (len < 0) {
	  throw new LScriptException("non-negative number expected at arg 3");
	} else if (offs <= 0) {
	  throw new LScriptException("positive number expected at arg 2");
	} else if (len == 0 || offs > slen) {
	  ret = new StringTerm("");
	} else {
	  int stop = offs + len;
	  if (stop > slen + 1) {
		ret = new StringTerm(s.substring(offs - 1));
	  } else {
		ret = new StringTerm(s.substring(offs - 1, stop -1));
	  }
	}
	return ret;
  }

  private Term len(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("S", args, paracnt, false, 1);
	StringTerm p1 = (StringTerm)paras[0];
	return new NumberTerm(p1.toString().length());
  }

  private Term concat(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("S", args, paracnt, true, 1);
	StringBuffer sb = new StringBuffer(100);
	for (int i = 0; i < paras.length; ++i) {
	  sb.append(paras[i].toString());
	}
	return new StringTerm(sb.toString());
  }

  private Term indexof(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("SS", args, paracnt, false, 1);
	StringTerm p1 = (StringTerm)paras[0];
	StringTerm p2 = (StringTerm)paras[1];
	return new NumberTerm(p1.toString().indexOf(p2.toString()) + 1);
  }

  private Term tostring(Term args, int paracnt)
  throws LScriptException
  {
	Term[] paras = eval.chkParas("?", args, paracnt, false, 1);
	return new StringTerm(paras[0].toString());
  }
}
