/*
 * File........: c:/ARC/PROG/java/gk/lscript/Term.java
 * Package.....: gk.lscript
 * Created.....: 98/08/06, Guido Krueger
 * RCS.........: $Revision: 1.5 $
 *               $Date: 1998/08/15 01:17:36 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.lscript;

public abstract class Term
{
  //Constants----------------------------------------------------
  public static final int NUMBER  =  1;
  public static final int STRING  =  2;
  public static final int SYMBOL  =  3;
  public static final int LIST    =  4;
  public static final int UNKNOWN = 99;

  //Package scope instance variables-----------------------------
  Term    next; //Pointer to next element for list structures
  int     type; //Runtime type information. Assigned by the derived clss.

  public Term()
  {
	next = null;
	type = UNKNOWN;
  }

  /**
   * Returns a clone of the object. Must be overloaded in the derived
   * class.
   */
  public abstract Term cloneterm();

  /**
   * Returns the runtime type of the object.
   */
  public int getType()
  {
	return type;
  }

  /**
   * Creates a String representation of the object. Must be overloaded in 
   * the dervied class.
   */
  public abstract String toString();

  /**
   * Returns true if the term is the empty list. Otherwise, false is 
   * returned.
   */
  public boolean isNIL()
  {
	if (type == LIST && ((ListTerm)this).isEmpty()) {
	  return true;
	}
	return false;
  }
}
