/*
 * File........: c:/ARC/PROG/java/gk/util/App.java
 * Package.....: gk.util
 * Created.....: 98/06/07, Guido Krueger
 * RCS.........: $Revision: 1.3 $
 *               $Date: 1998/07/28 11:45:31 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.util;

/**
 * The App class could be used to create standalone Java applications. 
 * Different to the standard way of writing applications, using an 
 * application object eases the task of accessing data/objects which 
 * have to be present in many different parts of the program. The static
 * getApp method of this class provides a simple way to retrieve the 
 * instantiated App object from anywhere in the application. The following
 * steps have to be performed:
 * <ul>
 * <li>An application-specific class has to be derived from the App class.
 * <li>The public static void main(String args[]) method should construct
 *     the object and call it's method appmain with args as argument:
 *     <pre>
 *     public static void main(String args[])
 *     {
 *       int exitcode = new BookFactory().appmain(args);
 *       System.exit(exitcode);
 *     }
 *     </pre>
 * <li>The appmain method should be overridden to hold the startup code
 *     of the application.
 * </ul>
 */
public class App
{
  //Instance variables
  static App app = null;

  /**
   * The base class constructor ensures that there will be only a single
   * App object application-wide.
   */
  protected App()
  {
	if (app != null) {
	  System.err.println("application object created twice");
	  System.exit(1);
	}
	app = this;
  }

  /**
   * This is the main application method, where application execution 
   * starts. It must be overridden in the derived application class. 
   */
  private int appmain(String args[])
  {
	System.out.println("App.appmain called");
	return 0;
  }

  /**
   * Returns the global application object. This method can be called
   * anywhere to get access to the application object.
   */
  public static App getApp()
  {
	return app;
  }
}
