/*
 * File........: c:/arc/prog/java/gk/util/sgml/Example1.java
 * Package.....: gk.util.sgml
 * Created.....: 98/08/18, Guido Krueger
 * RCS.........: $Revision$
 *               $Date$ $Author$
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.util.sgml;

import java.io.*;
import gk.util.*;

public class Example1
extends SGMLScanner
{
  //Pseudo constants
  static final String NL = System.getProperty("line.separator");

  //Instance variables
  protected Writer    out;
  protected boolean   insidepre;

  public Example1(Writer out)
  {
	this.out = out;
	this.insidepre = false;
  }

  //--- Overloaded callbacks from base class --------------------
  protected void element(SGMLElement element)
  {
	String name = element.getName();
	if (name.equals("html") && element.isStartTag()) {
	  write(getBuffer());
	  writeln("<!--&lt;pre> tags changed by gk.util.sgml.Example1-->");
	} else if (name.equals("pre")) {
	  if (element.isStartTag()) {
		writeln("<table border cellspacing=0 cellpadding=0>");
		insidepre = true;
	  } else {
		writeln("</table>");
		insidepre = false;
	  }
	} else {
	  write(getBuffer());
	}
  }

  protected void special(String content)
  {
	write(getBuffer());
  }

  protected void pcData(String data)
  {
	if (insidepre) {
	  String line;
	  boolean green = false;
	  int linenum = 1;
	  if (data.startsWith(NL)) {
		//ignore first NL after <pre> tag
		data = data.substring(NL.length());
	  }
	  while (data.length() > 0) {
		//look for next NL and set line String
		int pos = data.indexOf(NL);
		if (pos == -1) { //last line
		  line = data;
		  data = "";
		} else {
		  line = data.substring(0, pos);
		  data = data.substring(pos + NL.length());
		}
		//create table cell
		write("<tr bgcolor=\"" + (green ? "#E0FFE0" : "#FFFFFF") + "\"><td><tt>");
		//write line number
		write(Str.getFormatted("%03d ", linenum++));
		//output non-break spaces for leading spaces
		while (line.length() > 0) {
		  char c = line.charAt(0);
		  if (c == ' ') {
			write("&nbsp;");
			line = line.substring(1);
		  } else {
			break;
		  }
		}
		//output line
		write(line);
		writeln("</tt>");
		green = !green;
	  }
	} else {
	  //not inside <pre>: output data unchanged
	  write(data);
	}
  }

  //--- private methods------------------------------
  /**
   * Writes s to the output file.
   */
  private void write(String s)
  {
	try {
	  out.write(s);
	} catch (IOException e) {
	  System.err.println(e.toString());
	  System.exit(1);
	}
  }

  /**
   * Writes s + NL to the output file.
   */
  private void writeln(String s)
  {
	write(s + NL);
  }

  //--- main ----------------------------------------
  /**
   * Main method.
   */
  public static void main(String args[])
  {
	if (args.length != 2) {
	  System.err.println("usage: java Example1 <sourcefile> <destfile>");
	  System.exit(1);
	}
	try {
	  Writer out = new BufferedWriter(
                   new FileWriter(args[1]));
	  Reader in  = new BufferedReader(
                   new FileReader(args[0]));
	  Example1 scanner = new Example1(out);
	  scanner.startScanner(in);
	  out.close();
	  in.close();
	} catch (IOException e) {
	  System.err.println(e.toString());
	  System.exit(1);
	} catch (SGMLScannerException e) {
	  System.err.println(e.toString());
	  System.exit(1);
	}
  }
}
