/*
 * File........: c:/arc/prog/java/gk/util/sgml/SGMLElement.java
 * Package.....: gk.util.sgml
 * Created.....: 98/08/18, Guido Krueger
 * RCS.........: $Revision: 1.1 $
 *               $Date: 1998/09/08 22:40:31 $ $Author: guido $
 *
 * Copyright (c) 1998 Guido Krueger. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies.
 *
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE FOR ANY 
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING 
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
package gk.util.sgml;

import java.util.*;

public class SGMLElement
{
  StringBuffer  name;
  boolean       terminating;
  Vector        arguments;

  /**
   * Constructs an element with an empty name and argument list and the
   * terminating property set to false.
   */
  public SGMLElement()
  {
	name        = new StringBuffer(15);
	terminating = false;
	arguments   = new Vector();
  }

  /**
   * Sets the name of the element to the given String. name is converted
   * to lowercase before assigning it.
   */
  public void setName(String name)
  {
	this.name = new StringBuffer(name.toLowerCase());
  }

  /**
   * Appends the letter c to the name of the element. c is converted to
   * lowercase before appending it.
   */
  public void appendToName(char c)
  {
	this.name.append(Character.toLowerCase(c));
  }

  /**
   * Decides whether the element is a start or an end tag.
   */
  public void setTerminating(boolean terminating)
  {
	this.terminating = terminating;
  }

  /**
   * Adds the argument name/value to the argument list. name is converted
   * to lowercase before using it.
   */
  public void addArgument(
    StringBuffer name, 
	StringBuffer value, 
	boolean equalsign
  )
  {
	Argument arg  = new Argument();
	arg.name      = name.toString().toLowerCase();
	arg.value     = value.toString();
	arg.quoted    = arg.value.length() > 0 && arg.value.charAt(0) == '\"';
	arg.equalsign = equalsign;
	arguments.addElement(arg);
  }

  /**
   * Returns the (lowercase) name of this element.
   */
  public String getName()
  {
	return this.name.toString();
  }

  /**
   * Returns true if the element is an start tag.
   */
  public boolean isStartTag()
  {
	return !this.terminating;
  }

  /**
   * Returns true if the element is an end tag.
   */
  public boolean isEndTag()
  {
	return this.terminating;
  }

  /**
   * Returns the number of arguments found.
   */
  public int getArgumentCount()
  {
	return arguments.size();
  }

  /**
   * Returns the i-th argument. The value of i must be in the range 
   * 0 ... getArgumentCount() - 1.
   */
  public Argument getArgument(int i)
  {
	return (Argument) arguments.elementAt(i);
  }

  /**
   * Returns the argument with the given name. If there is no such
   * argument, the method returns null.
   */
  public Argument getArgument(String name)
  {
	Argument ret = null;
	name = name.toLowerCase();
	for (int i = arguments.size() - 1; i >= 0; --i) {
	  Argument arg = (Argument) arguments.elementAt(i);
	  if (name.equals(arg.name)) {
		ret = arg;
	  }
	}
	return ret;
  }

  /**
   * Creates a String representation of the name of this element
   * (i.e. "<list>" or "</h2>"). The name is always lowercase.
   */
  public String nameToString()
  {
	StringBuffer ret = new StringBuffer("<");
	if (isEndTag()) {
	  ret.append("/");
	}
	ret.append(getName());
	ret.append(">");
	return ret.toString();
  }

  /**
   * Creates a String representation of this element. Similar to the
   * nameToString() method, but includes the element's arguments also.
   */
  public String toString()
  {
	StringBuffer ret = new StringBuffer("<");
	if (isEndTag()) {
	  ret.append("/");
	}
	ret.append(getName());
	int j = getArgumentCount();
	for (int i = 0; i < j; ++i) {
	  Argument arg = getArgument(i);
	  ret.append(" " + arg.name);
	  if (arg.equalsign) {
		ret.append("=");
		ret.append(arg.value);
	  }
	}
	ret.append(">");
	return ret.toString();
  }
}
